float4x4 World;
float4x4 View;
float4x4 Projection;
Texture ColoredTexture;

sampler ColoredTextureSampler = sampler_state 
{
	texture = <ColoredTexture>;
	//magFilter = LINEAR;
	//minFilter = LINEAR;
	//mipFilter = LINEAR;
	//AddressU = mirror;
	//AddressV = mirror;
};


// TODO: add effect parameters here.

struct VertexShaderInput
{
    float4 Position : POSITION0;

    // TODO: add input channels such as texture
    // coordinates and vertex colors here.
    float2 textureCoordinates : TEXCOORD0;
};

struct VertexShaderOutput
{
    float4 Position : POSITION0;

    // TODO: add vertex shader outputs such as colors and texture
    // coordinates here. These values will automatically be interpolated
    // over the triangle, and provided as input to your pixel shader.
    float2 textureCoordinates : TEXCOORD0;
};

VertexShaderOutput VertexShaderFunction(VertexShaderInput input)
{
    //VertexShaderOutput output;
	VertexShaderOutput output = (VertexShaderOutput)0;  

    float4 worldPosition = mul(input.Position, World);
    float4 viewPosition = mul(worldPosition, View);
    output.Position = mul(viewPosition, Projection);

    // TODO: add your vertex shader code here.
    output.textureCoordinates = input.textureCoordinates;

    return output;
}

float4 PixelShaderFunction(VertexShaderOutput input) : COLOR0
{
    // TODO: add your pixel shader code here.
	return 1-tex2D(ColoredTextureSampler, input.textureCoordinates);
}

technique Technique1
{
    pass Pass1
    {
        // TODO: set renderstates here.

        VertexShader = compile vs_2_0 VertexShaderFunction();
        PixelShader = compile ps_2_0 PixelShaderFunction();
    }
}
