float4x4 WorldViewProjection;
Texture ColoredTexture;

sampler ColoredTextureSampler = sampler_state 
{
	texture = <ColoredTexture>;
	magFilter = LINEAR; // ??
	minFilter = LINEAR; // ??
	mipFilter = LINEAR; // ??
	AddressU = mirror;  // ??
	AddressV = mirror;  // ??
};


struct VertexShaderInput
{
    float4 Position : POSITION0;
    float2 textureCoordinates : TEXCOORD0;

    // TODO: add input channels such as texture
    // coordinates and vertex colors here.
};

struct VertexShaderOutput
{
    float4 Position : POSITION0;
    float2 textureCoordinates : TEXCOORD0;

    // TODO: add vertex shader outputs such as colors and texture
    // coordinates here. These values will automatically be interpolated
    // over the triangle, and provided as input to your pixel shader.
};

VertexShaderOutput VertexShaderFunction(VertexShaderInput input)
{
    VertexShaderOutput output 
		= (VertexShaderOutput)0;  // Why the assignment?

    output.Position = mul(input.Position, WorldViewProjection);
    output.textureCoordinates = input.textureCoordinates;

    // TODO: add your vertex shader code here.

    return output;
}

float4 PixelShaderFunction(VertexShaderOutput input) : COLOR0
{
    // TODO: add your pixel shader code here.

	// Looks like it is returning a scalar!!!
    return dot( tex2D(ColoredTextureSampler, input.textureCoordinates),
				float3(0.3, 0.59, 0.11));
				
//				float3(0.33, 0.33, 0.33));
}

technique Textured
{
    pass Pass1
    {
        // TODO: set renderstates here.

        VertexShader = compile vs_1_1 VertexShaderFunction();
        PixelShader = compile ps_1_1 PixelShaderFunction();
    }
}
