﻿using System;
using System.Threading;

namespace BowingSolved
{
    class Program
    {
        static void Main(string[] args)
        {
            Friend alphonse = new Friend("Alphonse");
            Friend gaston = new Friend("Gaston");
            new Thread(() => alphonse.bow(gaston)).Start();
            new Thread(() => gaston.bow(alphonse)).Start();
        }
    }

    class Friend
    {
        static object tieLock = new object();
        String name;
        public Friend(String name) { this.name = name; }

        public void bow(Friend bower)
        {
            int thisHash = GetHashCode();
            int bowerHash = bower.GetHashCode();
            if (thisHash < bowerHash)
            {
                lock (this)
                {
                    lock (bower)
                    {
                        Console.WriteLine(name + ": I bow to " + bower.name);
                        bower.bowBack(this);
                    }
                }
            }
            else if (thisHash > bowerHash)
            {
                lock (bower)
                {
                    lock (this)
                    {
                        Console.WriteLine(name + ": I bow to " + bower.name);
                        bower.bowBack(this);
                    }
                }
            }
            else
            {
                lock (tieLock)
                {
                    lock (this)
                    {
                        lock (bower)
                        {
                            Console.WriteLine(name + ": I bow to " + bower.name);
                            bower.bowBack(this);
                        }
                    }

                }
            }
        }
        public void bowBack(Friend bower)
        {
            //lock (this)
            {
                Console.WriteLine(name + ": I bow back to " + bower.name);
            }
        }
    }

}
