﻿using System;
using System.Threading;

/*
 * Demonstrate a Barrier.
 */

namespace _2.Barrier
{
    class Barrier
    {
        int n;  // Count of number of threads that will wait for the Barrier.
        public Barrier(int n) { this.n = n; }
        public void Wait() {
            lock (this) {
                if (n > 0) {
                    --n;
                    while (n > 0) Monitor.Wait(this);
                    Monitor.PulseAll(this);
                }
            }
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            const int n = 10;
            Barrier b = new Barrier(n);
            for (int i = 0; i < 10; ++i) {
                int tmp = i;
                new Thread(() =>
                {
                    Console.WriteLine("Thread: " + tmp + " sleeping " + tmp + " seconds.");
                    Thread.Sleep(tmp * 1000);
                    Console.WriteLine("Thread: " + tmp + " done sleeping.");
                    b.Wait();
                    Console.WriteLine("Thread: " + tmp + " done.");
                }
                    ).Start();
            }
        }
    }
}
