﻿using System;
using System.Threading;

/*
 * For those who like to live on the edge and find lock not to their liking
 * you can use the Monitor.Enter / Monitor.Exit pair.
 * Note that you need a try / finally to guarantee that the lock gets released
 * the lockTaken flag is to make sure we actually got the lock 
 * before we try to release it.
 */

namespace Monitoring
{
    class ThreadSafe
    {
        static int val1 = 1, val2 = 1;
        static object locker = new object(); 

        public static void Go()
        {
            bool lockTaken = false;
            try
            {
                Monitor.Enter(locker, ref lockTaken);
                if (val2 != 0) Console.WriteLine(val1 / val2);
                else Console.WriteLine("Too late");
                val2 = 0;
            }
            finally
            {
                if (lockTaken) Monitor.Exit(locker);
            }
        }
    }
    class Program
    {
        public static void Main(String[] args)
        {
            new Thread(ThreadSafe.Go).Start();
            new Thread(ThreadSafe.Go).Start();
            new Thread(ThreadSafe.Go).Start();
        }
    }
}
