﻿using System;
using System.Threading;

/*
 * 2A.Bowing
 * Fix the second thread problem with a join.  
 */

namespace Bowing
{
    class Program
    {
        static void Main(string[] args)
        {
            Friend alphonse = new Friend("Alphonse");
            Friend gaston = new Friend("Gaston");
            Thread t1 = new Thread(() => alphonse.bow(gaston));
            t1.Start();
            t1.Join();  // Do we really want to do this?
            new Thread( () => gaston.bow(alphonse) ).Start();
        }
    }

    class Friend {
        String name;
        public Friend(String name) {this.name = name;}

        public void bow(Friend bowie) {
            lock(this) {
                Console.WriteLine(name + ": I bow to " + bowie.name);
                bowie.bowBack(this);
            }
        }
        private void bowBack(Friend bower) {
            lock(this) {
                Console.WriteLine(name + ": I bow back to " + bower.name);
            }
        }


    }
}
