﻿using System;
using System.Threading;

/*
 * 2C.Bowing
 * Moves the second lock from bowBack to bow to give us a chance to arrange the order.
 * Note that the deadlock seems to "disappear".  Don't be fooled.  Add a Thread.Sleep(1).
 *    Interesting that neither Thread.Yield() or Thread.Sleep(0) succeeded in recreating the deadlock.
 *    Guessing it's a matter of priorities.
 */

namespace Bowing
{
    class Program
    {
        static void Main(string[] args)
        {
            Friend alphonse = new Friend("Alphonse");
            Friend gaston = new Friend("Gaston");
            new Thread( () => alphonse.bow(gaston) ).Start();
            new Thread( () => gaston.bow(alphonse) ).Start();
        }
    }

    class Friend {
        String name;
        public Friend(String name) {this.name = name;}

        public void bow(Friend bowie) {
            lock(this) {
                Thread.Sleep(1);
                lock (bowie)
                {
                    Console.WriteLine(name + ": I bow to " + bowie.name);
                    bowie.bowBack(this);
                }
            }
        }
        private void bowBack(Friend bower) {
            //lock(this) {
                Console.WriteLine(name + ": I bow back to " + bower.name);
            //}
        }


    }
}
