﻿using System;
using System.Threading;

/*
 * Demonstrate a Barrier.
 */

namespace _2B.Barrier
{
    class Barrier
    {
        int n;  // Count of number of threads that will wait for the Barrier.
        public Barrier(int n) { this.n = n; }
        public void Wait()
        {
            lock (this)
            {
                if (n > 0)
                {
                    --n;
                    while (n > 0) Monitor.Wait(this);
                    Monitor.PulseAll(this);
                }
            }
        }
    }

    class Program
    {
        static Barrier b = new Barrier(10);  // Needs to be static to be visible to the thread

        static void Main(string[] args)
        {
            for (int i = 0; i < 10; ++i) new Thread(Go).Start(i);
        }

        static void Go(object obj)
        {
            int num = (int)obj;
            Console.WriteLine("Thread: " + num + " sleeping " + num + " seconds.");
            Thread.Sleep(num * 1000);
            Console.WriteLine("Thread: " + num + " done sleeping.");
            b.Wait();
            Console.WriteLine("Thread: " + num + " done.");
        }
    }
}
