using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

/*
 * Invader
 * John Sterling
 * Moves and animates a single space invader as it moves across the screen
 * When it has moved all the way across, it reverses direction and drops lower.
 */

namespace Invader
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        Viewport viewport;

        const int INVADER_COUNT = 2; // How many images are there for the sprite
        const float ANIMATE_TIME = .3f;  // How long does it take between animations
        const float MOVE_TIME = .3f;  // How long does it take between movements
        const int MOVE_DISTANCE = 10; // How far does the sprite move horizontally each time
        const int DROP_DISTANCE = 10; // How far does the sprite move vertically each time

        float animateTimeRemaining = ANIMATE_TIME; // Track how long it's been since the last animation
        float moveTimeRemaining = MOVE_TIME; // Track how long it's been since the last movement
        int direction = 1; // Which direction are you moving?  1 is right and -1 is left.

        Vector2 invaderPosition = Vector2.Zero;

        int invaderIndex = 0;  // Which of the sprites in the sprite sheet are we using

        Texture2D invader;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here
            viewport = graphics.GraphicsDevice.Viewport;

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // TODO: use this.Content to load your game content here
            invader = Content.Load<Texture2D>(@"Sprites\Invader10");
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed
                || Keyboard.GetState().IsKeyDown(Keys.Escape))
                this.Exit();

            // TODO: Add your update logic here
            if (Keyboard.GetState().IsKeyDown(Keys.R))
            {
                Reset();
            }

            // Update the remaining time before the next animation and the next move
            animateTimeRemaining -= (float)gameTime.ElapsedGameTime.TotalSeconds;
            moveTimeRemaining -= (float)gameTime.ElapsedGameTime.TotalSeconds;

            // Is it time to animate?
            if (animateTimeRemaining <= 0)
            {
                animateTimeRemaining += ANIMATE_TIME; // Reset for next animation
                ++invaderIndex;   // Bump to the next sprite in the sprite sheet.
                invaderIndex %= INVADER_COUNT; // But wrap around if needed.
            }

            // Is it time to move?
            if (moveTimeRemaining <= 0)
            {
                moveTimeRemaining += MOVE_TIME; // Reset for next move
                invaderPosition.X += direction * MOVE_DISTANCE; // Switch directions
                // Stay on screen
                invaderPosition.X = MathHelper.Clamp(invaderPosition.X, 0, viewport.Width - invader.Width/INVADER_COUNT);
                // Have we hit an edge?
                if (invaderPosition.X == 0 || invaderPosition.X == viewport.Width - invader.Width / INVADER_COUNT)
                {
                    // If so, change direction
                    direction *= -1;
                    // and drop down.
                    invaderPosition.Y += DROP_DISTANCE;
                }
            }

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            // TODO: Add your drawing code here
            spriteBatch.Begin();
            spriteBatch.Draw(invader, // draw the invader
                invaderPosition,      // at its new postion
                // Pick the correct sprite from the sheet
                new Rectangle(invaderIndex * invader.Width / INVADER_COUNT, // Horizontal offset into sprite sheet
                              0, // Vertical offset into sprite sheet
                              invader.Width / INVADER_COUNT, // Width a sprite within the sprite sheet
                              invader.Height), // Height of the sprite
                Color.White);

            spriteBatch.End();

            base.Draw(gameTime);
        }

        // If the player wants to reset, then reposition the invader 
        // in the top left of the screen moving towards the right.
        private void Reset()
        {
            invaderIndex = 0;
            direction = 1;
            invaderPosition = Vector2.Zero;
        }
    }
}
