﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PrimePathBFS
{
    class Primes
    {
        public Primes(int max) { 
            primes = new bool[max + 1];
            ComputePrimes();
        }
        private bool[] primes;

        private void ComputePrimes()
        {
            // Initialize array claiming everything is prime;  
            for (int i = 2; i < primes.GetLength(0); ++i) primes[i] = true;
            // Sieve of Erastosthenes.
            // We can limit the highest "prime" factor 
            // we have to consider to  < sqrt(max).
            // (Don't care about 0 or 1)
            for (int i = 2; i < Math.Sqrt(primes.GetLength(0)); ++i)
                if (primes[i]) // If we haven't found any divisors
                    // Mark all multiples as non-prime
                    for (int j = 2 * i; j < primes.GetLength(0); j += i) primes[j] = false;
        }
        public bool isPrime(int n)
        {
            return primes[n];
        }

    }
}
