﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PrimePathBFS
{
    class Program
    {
        static Primes primeTester = new Primes(9999);
        class State
        {
            public int value;
            public State prior;

            public State(int value, State prior = null)
            {
                this.value = value;
                this.prior = prior;
            }
            public override bool Equals(Object o)
            {
                if (!(o is State)) return false;
                return ((State)o).value == value;
            }
            public override int GetHashCode()
            {
                return value;
            }
        }

        static void Main(string[] args)
        {
            Queue<State> openList = new Queue<State>();
            HashSet<State> closedSet = new HashSet<State>();
            //Primes primeTester = new Primes(9999);  // Identifies primes up to 9999

            Console.Write("Start: ");
            State start = new State(int.Parse(Console.ReadLine()));
            Console.Write("End: ");
            State goal = new State(int.Parse(Console.ReadLine()));

            // Is start a goal value?
            //if (start.Equals(goal))
            //{
            //    Console.WriteLine("Start is goal!");
            //    return;
            //}
            // Put start on open
            openList.Enqueue(start);

            // While there is something todo, do it.
            while (openList.Count != 0)
            {
                State current = openList.Dequeue();
                if (current.Equals(goal))
                {
                    // handle success
                    displayResult(current);
                    Console.WriteLine();
                    return;
                }
                closedSet.Add(current);
                // generate candidates
                foreach (State successor in generateSuccessors(current))
                {
                    //if (successor.Equals(goal))
                    //{
                    //    // handle success
                    //    displayResult(successor);
                    //    return;
                    //}
                    if (closedSet.Contains(successor)) continue;
                    openList.Enqueue(successor);
                }
            }

            // Nothing else to do, failure.
            Console.WriteLine("No path found");

        }

        static int computeNext(int n, int digit, int place)
        {
            int low = n % place;
            int high = n / (place * 10) * (place * 10);
            int result = high + (digit * place) + low;
            // Console.Write(result + " ");
            return result;
        }
        static List<State> generateSuccessors(State cur)
        {
            List<State> result = new List<State>();
            int nextCandidate;
            for (int digit = 0; digit < 10; ++digit)
            {
                // one's place
                nextCandidate = computeNext(cur.value, digit, 1);
                if (primeTester.isPrime(nextCandidate)) result.Add(new State(nextCandidate, cur));
                // ten's place
                nextCandidate = computeNext(cur.value, digit, 10);
                if (primeTester.isPrime(nextCandidate)) result.Add(new State(nextCandidate, cur));
                // hundred's place
                nextCandidate = computeNext(cur.value, digit, 100);
                if (primeTester.isPrime(nextCandidate)) result.Add(new State(nextCandidate, cur));
            }
            for (int digit = 1; digit < 10; ++digit)
            {
                // thousand's place
                nextCandidate = computeNext(cur.value, digit, 1000);
                if (primeTester.isPrime(nextCandidate)) result.Add(new State(nextCandidate, cur));
            }
            return result;
        }

        static void displayResult(State state)
        {
            if (state == null) return;
            displayResult(state.prior);
            Console.Write(state.value + " ");
        }
    }
}
