using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace Basic3D
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        const float ROTATION_SPEED = .010f;

        Matrix view = Matrix.CreateLookAt(new Vector3(0, 0, 5), Vector3.Zero, Vector3.Up);
        Matrix Projection;
        VertexPositionColor[] verts = new VertexPositionColor[3];
        BasicEffect effect;
        Matrix world = Matrix.Identity;
        Matrix rotations = Matrix.Identity;
        KeyboardState priorKeyboardState;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here
            Projection = Matrix.CreatePerspectiveFieldOfView(MathHelper.PiOver4,
                (float)Window.ClientBounds.Width / (float)Window.ClientBounds.Height,
                1,
                20);

            priorKeyboardState = Keyboard.GetState();
            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // TODO: use this.Content to load your game content here
            verts[0] = new VertexPositionColor(new Vector3(0, 1, 0), Color.HotPink);
            verts[1] = new VertexPositionColor(new Vector3(1, -1, 0), Color.Blue);
            verts[2] = new VertexPositionColor(new Vector3(-1, -1, 0), Color.Yellow);

            effect = new BasicEffect(GraphicsDevice);
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // TODO: Add your update logic here
            KeyboardState keyboardState = Keyboard.GetState();

            if (keyboardState.IsKeyDown(Keys.A))
            {
                rotations *= Matrix.CreateRotationY(-ROTATION_SPEED);
            }
            if (keyboardState.IsKeyDown(Keys.D))
            {
                rotations *= Matrix.CreateRotationY(ROTATION_SPEED);
            }
            if (keyboardState.IsKeyDown(Keys.W))
            {
                rotations *= Matrix.CreateRotationX(-ROTATION_SPEED);
            }
            if (keyboardState.IsKeyDown(Keys.S))
            {
                rotations *= Matrix.CreateRotationX(ROTATION_SPEED);
            }

            if (keyboardState.IsKeyDown(Keys.C) && !priorKeyboardState.IsKeyDown(Keys.C))
            {
                RasterizerState rs = new RasterizerState();
                if (GraphicsDevice.RasterizerState.CullMode == CullMode.None)
                    rs.CullMode = CullMode.CullCounterClockwiseFace;
                else
                    rs.CullMode = CullMode.None;
                GraphicsDevice.RasterizerState = rs;
            }

            world *= rotations;
            priorKeyboardState = keyboardState;
            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            // TODO: Add your drawing code here
            effect.View = view;
            effect.Projection = Projection;
            //effect.World = Matrix.Identity;
            effect.World = world;
            effect.VertexColorEnabled = true;

            foreach (EffectPass pass in effect.CurrentTechnique.Passes)
            {
                pass.Apply();
                GraphicsDevice.DrawUserPrimitives<VertexPositionColor>(PrimitiveType.TriangleStrip, verts, 0, 1);
            }

            base.Draw(gameTime);
        }
    }
}
