using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace Intro
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        Texture2D smiley;
        Texture2D splash;
        Vector2 position = Vector2.Zero;
        Viewport viewport;
        SpriteFont font;

        KeyboardState priorKeyboardState;

        //bool inSplash = true;
        enum GameState { SPLASH, PLAY, DONE };
        GameState gameState = GameState.SPLASH;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
            IsMouseVisible = true;
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here
            viewport = graphics.GraphicsDevice.Viewport;
            Console.WriteLine("Width: " + viewport.Width + ", Height: " + viewport.Height);
            priorKeyboardState = Keyboard.GetState();      
            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // TODO: use this.Content to load your game content here
            smiley = Content.Load<Texture2D>(@"Sprites\Smiley2");
            splash = Content.Load<Texture2D>(@"Sprites\Splash");
            font = Content.Load<SpriteFont>(@"Fonts\SpriteFont1");
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // TODO: Add your update logic here
            KeyboardState keyboardState = Keyboard.GetState();
            MouseState mouseState = Mouse.GetState();
            if (keyboardState.IsKeyDown(Keys.Enter) && priorKeyboardState.IsKeyUp(Keys.Enter)
                && gameState == GameState.PLAY)
            {
                gameState = GameState.DONE;
            }

            if (keyboardState.IsKeyDown(Keys.Enter) && priorKeyboardState.IsKeyUp(Keys.Enter) 
                && gameState == GameState.SPLASH)
            {
                gameState = GameState.PLAY;
            }

            if (keyboardState.IsKeyDown(Keys.Right))
            {
                position.X += 5;
            }
            if (keyboardState.IsKeyDown(Keys.Left))
            {
                position.X -= 5;
            }

            if (IsActive && mouseState.LeftButton.Equals(ButtonState.Pressed))
            {
                position.X = mouseState.X;
            }

            position.X = MathHelper.Clamp(position.X, 0, viewport.Width - smiley.Width);

            priorKeyboardState = keyboardState;
            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);
           // Console.WriteLine(GraphicsDevice == graphics.GraphicsDevice);

            // TODO: Add your drawing code here
            spriteBatch.Begin();
            if (gameState == GameState.SPLASH)
            {
                spriteBatch.Draw(splash, new Rectangle(0, 0, viewport.Width, viewport.Height), Color.Red);
            }
            else if (gameState == GameState.PLAY)
            {
                spriteBatch.Draw(smiley, position, Color.White);
            }
            else
            {
                spriteBatch.DrawString(font, "So long and ...", Vector2.Zero, Color.White);
            }
            spriteBatch.End();


            base.Draw(gameTime);
        }
    }
}
