using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace Pong
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        const int HEIGHT = 480;  // Table height
        const int WIDTH = 640;   // Table width
        const int INDENT = 20;  // How far in from the side to place the paddles
        const float PADDLE_SPEED = 2;  // PADDLE_SPEED for the paddles
        const int OFFSET_RANGE = 50;
        Random rand = new Random();

        Texture2D paddleSprite;
        Texture2D centerLine;
        Texture2D ballSprite;

        Vector2 leftPaddlePosition;
        Vector2 rightPaddlePosition;
        Vector2 ballPosition;

        float speed = 3;
        Vector2 ballDirection = Vector2.Zero;

        // turn == 1 means the ball serves to the right
        // turn == 0 means the ball serves to the left
        int turn = 1;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            graphics.PreferredBackBufferHeight = HEIGHT;
            graphics.PreferredBackBufferWidth = WIDTH;
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here
            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // TODO: use this.Content to load your game content here
            paddleSprite = Content.Load<Texture2D>(@"Sprites\paddle");
            centerLine = Content.Load<Texture2D>(@"Sprites\line");
            ballSprite = Content.Load<Texture2D>(@"Sprites\ball");
            Reset();
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // TODO: Add your update logic here
            KeyboardState keyboardState = Keyboard.GetState();

            if (keyboardState.IsKeyDown(Keys.R)) Reset();
            if (keyboardState.IsKeyDown(Keys.Escape)) Exit();

            // Paddle movement?
            if (keyboardState.IsKeyDown(Keys.Q)) leftPaddlePosition.Y -= PADDLE_SPEED;
            if (keyboardState.IsKeyDown(Keys.A)) leftPaddlePosition.Y += PADDLE_SPEED;
            if (keyboardState.IsKeyDown(Keys.P)) rightPaddlePosition.Y -= PADDLE_SPEED;
            if (keyboardState.IsKeyDown(Keys.OemSemicolon)) rightPaddlePosition.Y += PADDLE_SPEED;
            leftPaddlePosition.Y = MathHelper.Clamp(leftPaddlePosition.Y, 0, HEIGHT - paddleSprite.Height);
            rightPaddlePosition.Y = MathHelper.Clamp(rightPaddlePosition.Y, 0, HEIGHT - paddleSprite.Height);

            ballPosition += ballDirection * speed;

            Rectangle left = new Rectangle((int)leftPaddlePosition.X, (int)leftPaddlePosition.Y, paddleSprite.Width, paddleSprite.Height);
            Rectangle right = new Rectangle((int)rightPaddlePosition.X, (int)rightPaddlePosition.Y, paddleSprite.Width, paddleSprite.Height);
            Rectangle ballRect = new Rectangle((int)ballPosition.X, (int)ballPosition.Y, ballSprite.Width, ballSprite.Height);
            // Hits a paddle?
            if (ballRect.Intersects(right) || ballRect.Intersects(left))
            {
                ballDirection.X *= -1;
            }
            // Bounce of top or bottom?
            if (ballPosition.Y <= 0 || ballPosition.Y >= HEIGHT - ballSprite.Height)
            {
                ballDirection.Y *= -1;
            }
            // Goes off the end?
            if (ballPosition.X > WIDTH || ballPosition.X < -ballSprite.Width)
            {
                Reset();
                // Alternate who gets the serve
                turn *= -1;
                ballDirection.X *= turn;
            }
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.ForestGreen);

            // TODO: Add your drawing code here
            spriteBatch.Begin();
            spriteBatch.Draw(centerLine, new Vector2(WIDTH / 2 - centerLine.Width / 2, 0), Color.White);
            spriteBatch.Draw(paddleSprite, leftPaddlePosition, Color.White);
            spriteBatch.Draw(paddleSprite, rightPaddlePosition, Color.White);
            spriteBatch.Draw(ballSprite, ballPosition, Color.White);
            spriteBatch.End();

            base.Draw(gameTime);
        }

        public void Reset()
        {
            leftPaddlePosition = new Vector2(INDENT,
                                             HEIGHT / 2 - paddleSprite.Height / 2);
            rightPaddlePosition =
                new Vector2(WIDTH - INDENT - paddleSprite.Width,
                            HEIGHT / 2 - paddleSprite.Height / 2);

            ballPosition = new Vector2(WIDTH / 2 - ballSprite.Width / 2, HEIGHT / 2 - ballSprite.Height / 2);
            InitializeballDirectionection();
        }

        public void InitializeballDirectionection()
        {
            int deltaY = rand.Next(OFFSET_RANGE, HEIGHT / 2);
            //int sign = rand.Next(0, 1);  // Wrong.  second arg to Next is "exclusive"
            int sign = rand.Next(0, 2);
            if (sign == 0) deltaY *= -1;
            Console.Write("sign: " + sign + ", deltaY: " + deltaY);
            ballDirection = new Vector2(WIDTH / 2, deltaY);
            ballDirection.Normalize();
            Console.WriteLine(", ballDirection.Y: " + ballDirection.Y);
        }
    }
}
